#ifndef __INC_SKINDEF_H__
#define __INC_SKINDEF_H__



/*
*
*	Create the background for high/low denstity and slice it accordingly to skin definition.
*	Numbers and pencils bitmaps may or may not be provided by the skin.
*
*
* SKIN COLORS
*	Array of RGBColorType:
*	1. FrameFrame 	(clock text, Window title background, foreground color of toolbar)
*	2. FrameFill	(Window background, toolbar background)
*	3. Selection	(Board Selection color)
*	4. Invalid		(Board Row/Column/Block Invalid color)
* 	5. Hint			(Board Hint color)
*
*	1. and 2. are directly inserted into SystemPalette, to get them use 
*		UIColorGetTableEntryIndex(UIFormFrame), UIColorGetTableEntryIndex(UIFormFill).
*
*	3. 4. 5. color are exported as global variables.
*
*	The index member for 3. 4. 5. color defines the alpha channel (opacity).
*
*	If no colors are available in skin the defaults are used.
*
*
* SKIN NUMBERS RECTANGLES
*	Numers rectangle is an area where to draw given number within a single cell space
*	The reason for this is to cut off an unused space within bitmap 
*		(decrease its size, so it can be stored uncompressed) and increase drawing speed
*	Rectangle specifies offset (position within a cell) and size (each number in bitmap must have the same size)
*		-------
*		|     |
*		| --- |
*		| |n| |
*		| --- |
*		|     |
*		-------
*
*	If not defined, the defaults are used.
*
* SKIN DENSITY
*
*	HEX "DENS" ID ...
*		0x01
*	 
*	1|2|3
*	    1 = single density
*	    2 = double density
*	    3 = single + double density
*	    Default = 3 (if the resource not found)
*	
* SKIN SELECTIONS
* 
*	HEX "SELS" ID ...
*
*	b0 = 1|2|3|4
*	    1 = solid selection (selection color)
*	    2 = selection has frame
*	    3 = combination of both
*		4 = bitmap
*	    Default = 1 (if the resource not found)
*	 
*	b1 = 1-4
*		Specifies width of the selection frame in pixels
*
*	b2 = 1|2|3|4
*		side panel selection type (the same as selection type)
*
*	b3 = 1-4
*		Specifies width of the sidepanel frame in pixels
*
*	b4..b7 = frame color, e.g.
*	    0x00 0xFF 0xFF 0x00
*
*	b8..b11 = side panel frame color, e.g.
*		0x00 0xFF 0xFF 0x00
*
*	b12..b15 = side frame sel color
*
*	b16..b19 = popup sel color
*/

#define SkinID							2000
#define AuthorID						1999

#define CustomBmp_0						2002
#define CustomBmp_1						2004
#define CustomBmp_2						2006
#define CustomLargeNumbersBmp			2008
#define CustomSmallNumbersBmp			2010
#define CustomLargePencilsBmp			2012
#define CustomSmallPencilsBmp			2014
#define CustomNumbersRects				2016
#define CustomColorsDef					2018
#define CustomToolbarBmp				2020
#define CustomInputMethod1Bmp			2022
#define CustomInputMethod1SelectedBmp	2024
#define CustomInputMethod2Bmp			2026
#define CustomInputMethod2SelectedBmp	2028
#define CustomPencilInputBmp			2030
#define CustomPencilInputSelectedBmp	2032
#define CustomEraserBmp					2034
#define CustomEraserSelectedBmp			2036

#define CustomDensity					2038
#define CustomSelections				2040
#define CustomSelectionBmp				2042
#define CustomSidePanelSelBmp			2044
#define CustomDuplicateBmp_0			2046
#define CustomDuplicateBmp_1			2048
#define CustomDuplicateBmp_2			2050
#define CustomHintBmp					2052

#endif